<?php

use App\Http\Controllers\AdminCompanyController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\BranchOfficeController;
use App\Http\Controllers\BusinessAreaController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CompanyConfigurationController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CompanyDefaultPermissionsController;
use App\Http\Controllers\CustomerWalletController;
use App\Http\Controllers\DetailMembershipPaymentController;
use App\Http\Controllers\DetailPriceListBranchOfficeController;
use App\Http\Controllers\DetailPriceListCustomerController;
use App\Http\Controllers\DetailPriceListSalesmanController;
use App\Http\Controllers\DetailPriceListSegmentController;
use App\Http\Controllers\DocumentOfSalesController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\InitialStepController;
use App\Http\Controllers\InternalGuideController;
use App\Http\Controllers\MembershipController;
use App\Http\Controllers\MembershipCostsController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\PermissionsUserController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\PriceListController;
use App\Http\Controllers\PriceListProductsController;
use App\Http\Controllers\ProductAttributeController;
use App\Http\Controllers\ProductClassificationController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductsImportController;
use App\Http\Controllers\ProofPaymentController;
use App\Http\Controllers\ReferenceDocumentsController;
use App\Http\Controllers\SaleChannelController;
use App\Http\Controllers\SalesmanBranchOfficeController;
use App\Http\Controllers\SalesmanController;
use App\Http\Controllers\SegmentController;
use App\Http\Controllers\ShoppingCartController;
use App\Http\Controllers\SoftnetController;
use App\Http\Controllers\SpecificAttributesController;
use App\Http\Controllers\SpecificSubcategoryController;
use App\Http\Controllers\SpecificUsesController;
use App\Http\Controllers\StockProductController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\SubcategoryController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TransbankController;
use App\Http\Controllers\TypeProductController;
use App\Http\Controllers\TypeSaleController;
use App\Http\Controllers\UbigeoController;
use App\Http\Controllers\UsageAttributesController;
use App\Http\Controllers\WayToPayController;
use App\Http\Controllers\TypeAttributeController;
use App\Http\Controllers\ClientAddressController;
use App\Http\Controllers\UserErpController;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::prefix('v1')->middleware('jwt', 'permissionsUser')->group(function () {
    Route::group(['prefix' => 'auth'], function () {
        Route::post('login', [AuthController::class, 'login'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::post('me', [AuthController::class, 'me']);
        Route::post('logout', [AuthController::class, 'logout']);
        Route::post('refresh', [AuthController::class, 'refresh']);
        Route::get('validateToken', [AuthController::class, 'validateToken'])->withoutMiddleware(['jwt','permissionsUser']);
    });

    Route::group(['prefix' => 'ubigeo'], function () {
        Route::get('/listCountries', [UbigeoController::class, 'listCountries']);
        Route::get('/listDepartments', [UbigeoController::class, 'listDepartments']);
        Route::get('/listProvinces', [UbigeoController::class, 'listProvinces']);
        Route::get('/listDistricts', [UbigeoController::class, 'listDistricts']);
    });

    Route::group(['prefix' => 'company'], function () {
        Route::get('/', [CompanyController::class, 'list']);
        Route::post('register', [CompanyController::class, 'register']);
        Route::patch('{id}', [CompanyController::class, 'update']);
        Route::delete('{id}', [CompanyController::class, 'delete']);
    });

    Route::group(['prefix' => 'user'], function () {
        Route::get('/', [UserController::class, 'list']);
        Route::get('listByCompany', [UserController::class, 'listByCompany']);
        Route::get('listUserType', [UserController::class, 'listUserType']);
        Route::get('listPrivilege', [UserController::class, 'listPrivilege']);
        Route::post('register', [UserController::class, 'register']);
        Route::post('registerBySuperadmin', [UserController::class, 'registerBySuperadmin']);
        Route::post('changePassword', [UserController::class, 'changePassword']);
        Route::post('forgotPassword', [UserController::class, 'forgotPassword'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::patch('changeStatus/{id}', [UserController::class, 'changeStatus']);
        Route::patch('{id}', [UserController::class, 'update']);
        Route::delete('{id}', [UserController::class, 'delete']);

        Route::get('type', [UserController::class, 'listType']);
    });

    Route::group(['prefix' => 'userERP'], function () {
        Route::get('/verify/{iduser}', [UserErpController::class, 'verify']);
        Route::post('/register', [UserErpController::class, 'register']);
        Route::patch('/update/{id}', [UserErpController::class, 'update']);
        Route::delete('/delete/{id}', [UserErpController::class, 'delete']);
    });

    Route::group(['prefix' => 'documentofsales'], function () {
        Route::get('/', [DocumentOfSalesController::class, 'list']);
        Route::get('listByCompany', [DocumentOfSalesController::class, 'listByCompany']);
    });

    Route::group(['prefix' => 'waytopay'], function () {
        Route::get('/', [WayToPayController::class, 'list']);
        Route::get('listByCompany', [WayToPayController::class, 'listByCompany']);
        Route::get('listPaymentCuotas', [WayToPayController::class, 'listPaymentCuotas']);
        Route::get('listPaymentTools', [WayToPayController::class, 'listPaymentTools']);
        Route::post('assignPaymentMethod', [WayToPayController::class, 'assignPaymentMethod']);
        Route::post('updatePaymentAssignment/{id}', [WayToPayController::class, 'updatePaymentAssignment']);
    });

    Route::group(['prefix' => 'branchoffice'], function () {
        Route::get('/', [BranchOfficeController::class, 'list']);
        Route::get('listByCompany', [BranchOfficeController::class, 'listByCompany']);
        Route::get('listTypesBranches', [BranchOfficeController::class, 'listTypesBranches']);
        Route::post('register', [BranchOfficeController::class, 'register']);
        Route::patch('{id}', [BranchOfficeController::class, 'update']);
        Route::delete('{id}', [BranchOfficeController::class, 'delete']);
    });

    Route::group(['prefix' => 'store'], function () {
        Route::get('/', [StoreController::class, 'list']);
        Route::get('/erp', [StoreController::class, 'importStore']);
        Route::post('register', [StoreController::class, 'register']);
        Route::patch('changeStatus/{id}', [StoreController::class, 'changeStatus']);
        Route::patch('{id}', [StoreController::class, 'update']);
        Route::delete('{id}', [StoreController::class, 'delete']);
    });

    Route::group(['prefix' => 'businessarea'], function () {
        Route::get('/', [BusinessAreaController::class, 'list']);
        Route::post('register', [BusinessAreaController::class, 'register']);
        Route::patch('changeStatus/{id}', [BusinessAreaController::class, 'changeStatus']);
        Route::patch('{id}', [BusinessAreaController::class, 'update']);
        Route::delete('{id}', [BusinessAreaController::class, 'delete']);
    });

    Route::group(['prefix' => 'typeattribute'], function () {
        Route::get('/', [TypeAttributeController::class, 'list']);
        Route::get('listByCompany', [TypeAttributeController::class, 'listByCompany']);
        Route::post('register', [TypeAttributeController::class, 'register']);
        Route::patch('changeStatus/{id}', [TypeAttributeController::class, 'changeStatus']);
        Route::patch('{id}', [TypeAttributeController::class, 'update']);
        Route::delete('{id}', [TypeAttributeController::class, 'delete']);
    });

    Route::group(['prefix' => 'productattribute'], function () {
        Route::get('/', [ProductAttributeController::class, 'list']);
        Route::get('listByCompany', [ProductAttributeController::class, 'listByCompany']);
        Route::post('register', [ProductAttributeController::class, 'register']);
        Route::post('dataOptimizated', [ProductAttributeController::class, 'dataOptimizated']);
        Route::patch('changeStatus/{id}', [ProductAttributeController::class, 'changeStatus']);
        Route::patch('{id}', [ProductAttributeController::class, 'update']);
        Route::delete('{id}', [ProductAttributeController::class, 'delete']);
    });

    Route::group(['prefix' => 'usageattributes'], function () {
        Route::get('/', [UsageAttributesController::class, 'list']);
        Route::get('listByCompany', [UsageAttributesController::class, 'listByCompany']);
        Route::post('register', [UsageAttributesController::class, 'register']);
        Route::post('productos/{id}', [UsageAttributesController::class, 'relationProducts']);
        Route::patch('{id}', [UsageAttributesController::class, 'update']);
        Route::delete('{id}', [UsageAttributesController::class, 'delete']);
    });

    Route::group(['prefix' => 'specificattributes'], function () {
        Route::get('/', [SpecificAttributesController::class, 'list']);
        Route::get('listByCompany', [SpecificAttributesController::class, 'listByCompany']);
        Route::get('listByattribute', [SpecificAttributesController::class, 'listByattribute']);
        Route::post('register', [SpecificAttributesController::class, 'register']);
        Route::patch('{id}', [SpecificAttributesController::class, 'update']);
        Route::delete('{id}', [SpecificAttributesController::class, 'delete']);
    });

    Route::group(['prefix' => 'specificuses'], function () {
        Route::get('/', [SpecificUsesController::class, 'list']);
        Route::get('listByCompany', [SpecificUsesController::class, 'listByCompany']);
        Route::get('listByUse', [SpecificUsesController::class, 'listByUse']);
        Route::post('register', [SpecificUsesController::class, 'register']);
        Route::patch('{id}', [SpecificUsesController::class, 'update']);
        Route::delete('{id}', [SpecificUsesController::class, 'delete']);
    });

    Route::group(['prefix' => 'category'], function () {
        Route::get('/', [CategoryController::class, 'list']);
        Route::get('listByCompany', [CategoryController::class, 'listByCompany']);
        Route::get('listWithProducts', [CategoryController::class, 'listWithProducts']);
        Route::get('listDuplicated', [CategoryController::class, 'listDuplicated']);
        Route::get('reviewData', [CategoryController::class, 'reviewData']);
        Route::post('register', [CategoryController::class, 'register']);
        Route::post('unifyDuplicated', [CategoryController::class, 'unifyDuplicated']);
        Route::patch('{id}', [CategoryController::class, 'update']);
        Route::delete('{id}', [CategoryController::class, 'delete']);
    });

    Route::group(['prefix' => 'subcategory'], function () {
        Route::get('/', [SubcategoryController::class, 'list']);
        Route::get('listByCompany', [SubcategoryController::class, 'listByCompany']);
        Route::get('listWithProducts', [SubcategoryController::class, 'listWithProducts']);
        Route::get('listByCategory', [SubcategoryController::class, 'listByCategory']);
        Route::get('listDuplicated', [SubcategoryController::class, 'listDuplicated']);
        Route::get('reviewData', [SubcategoryController::class, 'reviewData']);
        Route::post('register', [SubcategoryController::class, 'register']);
        Route::post('unifyDuplicated', [SubcategoryController::class, 'unifyDuplicated']);
        Route::patch('{id}', [SubcategoryController::class, 'update']);
        Route::delete('{id}', [SubcategoryController::class, 'delete']);
    });

    Route::group(['prefix' => 'specificsubcategory'], function () {
        Route::get('/', [SpecificSubcategoryController::class, 'list']);
        Route::get('listByCompany', [SpecificSubcategoryController::class, 'listByCompany']);
        Route::get('listBySubcategory', [SpecificSubcategoryController::class, 'listBySubcategory']);
        Route::post('register', [SpecificSubcategoryController::class, 'register']);
        Route::patch('{id}', [SpecificSubcategoryController::class, 'update']);
        Route::delete('{id}', [SpecificSubcategoryController::class, 'delete']);
    });

    Route::group(['prefix' => 'product'], function () {
        Route::get('/', [ProductController::class, 'list']);
        Route::get('listByCompany', [ProductController::class, 'listByCompany']);
        Route::get('erp', [ProductController::class, 'listErpProducts']);
        Route::get('downloadTemplate', [ProductController::class, 'downloadTemplate']);
        Route::post('register', [ProductController::class, 'register']);
        Route::post('importProductExcel', [ProductController::class, 'importProductExcel']);
        Route::post('update/{id}', [ProductController::class, 'update']);
        Route::delete('{id}', [ProductController::class, 'delete']);
    });

    Route::group(['prefix' => 'productImport'], function () {
        Route::get('/', [ProductsImportController::class, 'list']);
        Route::get('validateUser', [ProductsImportController::class, 'validateUserImport']);
        Route::post('update/{id}', [ProductsImportController::class, 'update']);
        Route::post('import/{id}', [ProductsImportController::class, 'import']);
        Route::post('importMassive', [ProductsImportController::class, 'importMassive']);
        Route::delete('{id}', [ProductsImportController::class, 'delete']);
    });

    Route::group(['prefix' => 'typeProduct'], function () {
        Route::get('/', [TypeProductController::class, 'list']);
        Route::post('register', [TypeProductController::class, 'register']);
        Route::patch('{id}', [TypeProductController::class, 'update']);
        Route::delete('{id}', [TypeProductController::class, 'delete']);
    });

    Route::group(['prefix' => 'classification'], function () {
        Route::get('/', [ProductClassificationController::class, 'list']);
        Route::post('register', [ProductClassificationController::class, 'register']);
        Route::patch('{id}', [ProductClassificationController::class, 'update']);
        Route::delete('{id}', [ProductClassificationController::class, 'delete']);
    });

    Route::group(['prefix' => 'segment'], function () {
        Route::get('/', [SegmentController::class, 'list']);
        Route::post('register', [SegmentController::class, 'register']);
        Route::patch('{id}', [SegmentController::class, 'update']);
        Route::delete('{id}', [SegmentController::class, 'delete']);
    });

    Route::group(['prefix' => 'saleChannel'], function () {
        Route::get('/', [SaleChannelController::class, 'list']);
        Route::post('register', [SaleChannelController::class, 'register']);
        Route::patch('{id}', [SaleChannelController::class, 'update']);
        Route::delete('{id}', [SaleChannelController::class, 'delete']);
    });

    Route::group(['prefix' => 'supplier'], function () {
        Route::get('/', [SupplierController::class, 'list']);
        Route::post('register', [SupplierController::class, 'register']);
        Route::patch('{id}', [SupplierController::class, 'update']);
        Route::delete('{id}', [SupplierController::class, 'delete']);
    });

    Route::group(['prefix' => 'client-address'], function () {
        Route::get('/', [ClientAddressController::class, 'list']);
        Route::post('/register', [ClientAddressController::class, 'register']);
        Route::patch('{id}', [ClientAddressController::class, 'update']);
        Route::delete('{id}', [ClientAddressController::class, 'delete']);
    });

    Route::group(['prefix' => 'adminCompany'], function () {
        Route::get('/', [AdminCompanyController::class, 'list']);
        Route::post('register', [AdminCompanyController::class, 'register']);
        Route::patch('{id}', [AdminCompanyController::class, 'update']);
        Route::delete('{id}', [AdminCompanyController::class, 'delete']);
    });

    Route::group(['prefix' => 'salesman'], function () {
        Route::get('/', [SalesmanController::class, 'list']);
        Route::post('register', [SalesmanController::class, 'register']);
        Route::patch('{id}', [SalesmanController::class, 'update']);
        Route::delete('{id}', [SalesmanController::class, 'delete']);
    });

    Route::group(['prefix' => 'pricelist'], function () {
        Route::get('/', [PriceListController::class, 'list']);
        Route::get('listByCompany', [PriceListController::class, 'listByCompany']);
        Route::post('register', [PriceListController::class, 'register']);
        Route::post('addProducts', [PriceListController::class, 'addProducts']);
        Route::post('duplicate', [PriceListController::class, 'duplicate']);
        Route::patch('{id}', [PriceListController::class, 'update']);
        Route::delete('{id}', [PriceListController::class, 'delete']);
    });

    Route::group(['prefix' => 'pricelistproducts'], function () {
        Route::get('/', [PriceListProductsController::class, 'list']);
        Route::post('register', [PriceListProductsController::class, 'register']);
        Route::patch('{id}', [PriceListProductsController::class, 'update']);
        Route::delete('{id}', [PriceListProductsController::class, 'delete']);
        Route::get('products', [PriceListProductsController::class, 'listProduct']);
        Route::get('search', [PriceListProductsController::class, 'searchProduct']);
    });

    Route::group(['prefix' => 'salesmanBranchOfficeService'], function () {
        Route::get('/', [SalesmanBranchOfficeController::class, 'list']);
        Route::post('register', [SalesmanBranchOfficeController::class, 'register']);
        Route::patch('{id}', [SalesmanBranchOfficeController::class, 'update']);
        Route::delete('{id}', [SalesmanBranchOfficeController::class, 'delete']);
    });

    Route::group(['prefix' => 'customerWallet'], function () {
        Route::get('/', [CustomerWalletController::class, 'list']);
        Route::post('register', [CustomerWalletController::class, 'register']);
        Route::patch('{id}', [CustomerWalletController::class, 'update']);
        Route::delete('{id}', [CustomerWalletController::class, 'delete']);
    });

    Route::group(['prefix' => 'stockProduct'], function () {
        Route::get('/', [StockProductController::class, 'list']);
        Route::get('/availability', [StockProductController::class, 'searchProductAvailability']);
        Route::post('register', [StockProductController::class, 'register']);
        Route::patch('/reduce', [StockProductController::class, 'reduceStock']);
        Route::patch('/{id}', [StockProductController::class, 'update']);
        Route::delete('{id}', [StockProductController::class, 'delete']);
    });

    Route::group(['prefix' => 'priceListBranchOffice'], function () {
        Route::get('/', [DetailPriceListBranchOfficeController::class, 'list']);
        Route::post('register', [DetailPriceListBranchOfficeController::class, 'register']);
        Route::patch('{id}', [DetailPriceListBranchOfficeController::class, 'update']);
        Route::delete('{id}', [DetailPriceListBranchOfficeController::class, 'delete']);
    });

    Route::group(['prefix' => 'priceListSegment'], function () {
        Route::get('/', [DetailPriceListSegmentController::class, 'list']);
        Route::post('register', [DetailPriceListSegmentController::class, 'register']);
        Route::patch('{id}', [DetailPriceListSegmentController::class, 'update']);
        Route::delete('{id}', [DetailPriceListSegmentController::class, 'delete']);
    });

    Route::group(['prefix' => 'priceListCustomer'], function () {
        Route::get('/', [DetailPriceListCustomerController::class, 'list']);
        Route::post('register', [DetailPriceListCustomerController::class, 'register']);
        Route::patch('{id}', [DetailPriceListCustomerController::class, 'update']);
        Route::delete('{id}', [DetailPriceListCustomerController::class, 'delete']);
    });

    Route::group(['prefix' => 'priceListSalesman'], function () {
        Route::get('/', [DetailPriceListSalesmanController::class, 'list']);
        Route::post('register', [DetailPriceListSalesmanController::class, 'register']);
        Route::patch('{id}', [DetailPriceListSalesmanController::class, 'update']);
        Route::delete('{id}', [DetailPriceListSalesmanController::class, 'delete']);
    });

    Route::group(['prefix' => 'shoppingCart'], function () {
        Route::get('/', [ShoppingCartController::class, 'list']);
        Route::get('{id}', [ShoppingCartController::class, 'listCustomer']);
        Route::post('register', [ShoppingCartController::class, 'register']);
        Route::patch('discountGlobal/{id}', [ShoppingCartController::class, 'changeGlobalDiscount']);
        Route::patch('updateProduct/{id}', [ShoppingCartController::class, 'updateProduct']);
        Route::patch('assignCustomer/{id}', [ShoppingCartController::class, 'assignCustomer']);
        Route::delete('deleteProduct/{id}', [ShoppingCartController::class, 'deleteProduct']);
    });

    Route::group(['prefix' => 'referenceDocument'], function () {
        Route::get('/', [ReferenceDocumentsController::class, 'list']);
        Route::post('register', [ReferenceDocumentsController::class, 'register']);
        Route::patch('{id}', [ReferenceDocumentsController::class, 'update']);
        Route::delete('{id}', [ReferenceDocumentsController::class, 'delete']);
    });

    Route::group(['prefix' => 'ticket'], function () {
        Route::get('/', [TicketController::class, 'list']);
        Route::get('/salesBook', [TicketController::class, 'salesBook']);
        Route::post('register', [TicketController::class, 'register']);
        Route::post('document', [TicketController::class, 'generateDocument']);
        // Route::patch('{id}', [SupplierController::class, 'update']);
        Route::delete('{id}', [TicketController::class, 'delete']);
    });

    Route::group(['prefix' => 'transbank'], function () {
        Route::get('/confirmar_pago_wp', [TransbankController::class, 'confirmar_pago_wp'])->name('confirmar_pago_wp')->withoutMiddleware(['jwt','permissionsUser']);
        Route::get('/payments', [TransbankController::class, 'payments']);
        Route::post('/pay/{id}', [TransbankController::class, 'startWebpayPlusTransaction'])->withoutMiddleware(['permissionsUser']);;
        Route::patch('/assignCredentials', [TransbankController::class, 'assignCredentials']);
    });

    Route::group(['prefix' => 'configuration'], function () {
        Route::get('/', [CompanyConfigurationController::class, 'list']);
        Route::post('/', [CompanyConfigurationController::class, 'update']);
    });

    Route::group(['prefix' => 'permissions'], function () {
        Route::get('/', [PermissionsController::class, 'list']);
    });

    Route::group(['prefix' => 'companyDefaultPermissions'], function () {
        Route::get('/', [CompanyDefaultPermissionsController::class, 'list']);
        Route::patch('{id}', [CompanyDefaultPermissionsController::class, 'update']);
    });

    Route::group(['prefix' => 'permissionsUser'], function () {
        Route::get('/', [PermissionsUserController::class, 'list']);
        Route::post('register', [PermissionsUserController::class, 'register']);
        Route::patch('{id}', [PermissionsUserController::class, 'update']);
        Route::delete('{id}', [PermissionsUserController::class, 'delete']);
    });

    Route::group(['prefix' => 'typeSale'], function () {
        Route::get('/', [TypeSaleController::class, 'list']);
        Route::post('register', [TypeSaleController::class, 'register']);
        Route::patch('{id}', [TypeSaleController::class, 'update']);
        Route::delete('{id}', [TypeSaleController::class, 'delete']);
    });

    Route::group(['prefix' => 'plan'], function () {
        Route::get('/', [PlanController::class, 'list']);
    });

    Route::group(['prefix' => 'membership'], function () {
        Route::get('/', [MembershipController::class, 'list'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::get('/getMembershipProfessional', [MembershipController::class, 'getMembershipProfessional']);
        Route::get('/plans', [MembershipController::class, 'getPlans'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::post('/', [MembershipController::class, 'store']);
    });

    Route::group(['prefix' => 'membershipCosts'], function () {
        Route::get('/', [MembershipCostsController::class, 'list'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::get('/costsAll', [MembershipCostsController::class, 'getCostsAll']);
        Route::get('/costs', [MembershipCostsController::class, 'getCostsTreatment'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::get('/{id}', [MembershipCostsController::class, 'getById'])->withoutMiddleware(['jwt','permissionsUser']);
        Route::post('/', [MembershipCostsController::class, 'store']);
        Route::patch('/{id}', [MembershipCostsController::class, 'edit']);
        Route::delete('/{id}', [MembershipCostsController::class, 'destroy']);
    });

    Route::group(['prefix' => 'membershipPayment'], function () {
        Route::get('/', [DetailMembershipPaymentController::class, 'list']);
        Route::get('byCompany/{id}', [DetailMembershipPaymentController::class, 'getPaymentMembershipByCompany']);
        Route::get('/getPaymentsByIdMembership', [DetailMembershipPaymentController::class, 'getPaymentsByIdMembership']);
        Route::get('/getExpired', [DetailMembershipPaymentController::class, 'getCompanysWithMembershipExpired']);
        Route::post('/', [DetailMembershipPaymentController::class, 'store']);
        Route::post('/sendMailMembershipExpired/{id}', [DetailMembershipPaymentController::class, 'sendMailMembershipExpired']);
    });

    Route::group(['prefix' => 'softnet'], function () {
        Route::get('/formaPago', [SoftnetController::class, 'getFormaPagoERP']);
        Route::get('/areaNegocio', [SoftnetController::class, 'getAreaNegocio']);
        Route::get('/vendedor', [SoftnetController::class, 'getVendedor']);
        Route::get('/warehouse', [SoftnetController::class, 'getWareHouseERP']);
        Route::get('/businessArea', [SoftnetController::class, 'getBusinessAreaERP']);
        Route::get('/products', [SoftnetController::class, 'getProductsERP']);
        Route::get('/category', [SoftnetController::class, 'getCategoryERP']);
        Route::get('/subcategory', [SoftnetController::class, 'getSubcategoryERP']);
        Route::get('/specificsubcategory', [SoftnetController::class, 'getSpecificSubcategoryERP']);
        Route::get('/user', [SoftnetController::class, 'getUserERP']);
        Route::get('/customer', [SoftnetController::class, 'getCustomerERP']);
        Route::get('/supplier', [SoftnetController::class, 'getSupplierERP']);
        Route::get('/branchOffice', [SoftnetController::class, 'getBranchOfficeERP']);
        Route::post('/importFormaPago', [SoftnetController::class, 'importFormaPago']);
        Route::post('/importSelectFormaPago', [SoftnetController::class, 'importSelectFormaPago']);
        Route::post('/importWarehouse', [SoftnetController::class, 'importWarehouse']);
        Route::post('/importSelectWarehouse', [SoftnetController::class, 'importSelectWarehouse']);
        Route::post('/importBusinessArea', [SoftnetController::class, 'importBusinessArea']);
        Route::post('/importSelectBusinessArea', [SoftnetController::class, 'importSelectBusinessArea']);
        Route::post('/importProducts', [SoftnetController::class, 'importProducts']);
        Route::post('/importSelectProducts', [SoftnetController::class, 'importSelectProducts']);
        Route::post('/importCategory', [SoftnetController::class, 'importCategory']);
        Route::post('/importSelectCategory', [SoftnetController::class, 'importSelectCategory']);
        Route::post('/importSubcategory', [SoftnetController::class, 'importSubcategory']);
        Route::post('/importSelectSubcategory', [SoftnetController::class, 'importSelectSubcategory']);
        Route::post('/importSpecificsubcategory', [SoftnetController::class, 'importSpecificsubcategory']);
        Route::post('/importSelectSpecificsubcategory', [SoftnetController::class, 'importSelectSpecificsubcategory']);
        Route::post('/importSupplier', [SoftnetController::class, 'importSupplier']);
        Route::post('/importSelectSupplier', [SoftnetController::class, 'importSelectSupplier']);
        Route::post('/importCustomer', [SoftnetController::class, 'importCustomer']);
        Route::post('/importSelectCustomer', [SoftnetController::class, 'importSelectCustomer']);
        Route::post('/importBranchOffice', [SoftnetController::class, 'importBranchOffice']);
        Route::post('/importSelectBranchOffice', [SoftnetController::class, 'importSelectBranchOffice']);
        Route::post('/issueTicket/{id}', [SoftnetController::class, 'issueTicket']);
    });

    Route::group(['prefix' => 'internalGuide'], function () {
        Route::get('/', [InternalGuideController::class, 'list']);
        Route::post('register', [InternalGuideController::class, 'register']);
        Route::delete('{id}', [InternalGuideController::class, 'delete']);
    });

    Route::group(['prefix' => 'bank'], function () {
        Route::get('/', [BankController::class, 'list']);
    });

    Route::group(['prefix' => 'proofPayment'], function () {
        Route::get('/', [ProofPaymentController::class, 'list']);
        Route::get('/paymentMethod', [ProofPaymentController::class, 'listPaymentMethod']);
        Route::get('/pdf', [ProofPaymentController::class, 'getPDF']);
        Route::get('/savePDF', [ProofPaymentController::class, 'savePDF']);
        Route::post('/sendEmail/{id}', [ProofPaymentController::class, 'sendEmail']);
        Route::patch('/acceptDocument/{id}', [ProofPaymentController::class, 'acceptDocument']);
        Route::delete('{id}', [ProofPaymentController::class, 'delete']);
    });

    Route::group(['prefix' => 'initialStep'], function () {
        Route::get('/', [InitialStepController::class, 'list']);
        Route::get('detail', [InitialStepController::class, 'listDetail']);
        Route::post('register', [InitialStepController::class, 'register']);
        Route::post('changeOrder', [InitialStepController::class, 'changeOrder']);
        Route::patch('{id}', [InitialStepController::class, 'update']);
        Route::delete('{id}', [InitialStepController::class, 'delete']);
    });

    Route::group(['prefix' => 'import'], function () {
        Route::get('/', [ImportController::class, 'list']);
        Route::get('download/{id}', [ImportController::class, 'downloadTemplate']);
        Route::post('register', [ImportController::class, 'register']);
        Route::post('update/{id}', [ImportController::class, 'update']);
        Route::delete('{id}', [ImportController::class, 'delete']);
    });

});

Route::fallback(function () {
    return [
        'timestamp' => Carbon::now()->toDateTimeString(),
        'code'      => 404,
        'status'    => false,
        'data'      => ['message' => 'Acceso restringido.']
    ];
});
