<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante de pago</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .title {
            /* Título inicial */
            text-align: left;
            font-size: 20px;
            font-weight: bold;
        }

        .simple-text {
            /* Textos simples */
            font-size: 12px;
            font-weight: bold;
            line-height: 0.5;
            color: #525151;
        }

        .column-2 {
            /* Columnas en dos */
            float: left;
            width: 50%;
        }

        .simple-text span {
            color: black;
            font-weight: bold;
            min-width: 60px;
            display: inline-block;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 2px;
            margin-bottom: 2px;
        }

        td,
        th {
            border: 1px solid #000000;
            text-align: center;
            vertical-align: middle;
            margin-top: 2px;
            margin-bottom: 2px;
            padding: 1px
        }
    </style>
</head>

<body>
    {{-- Encabezado --}}
    <div>
        <h1 class="title">COMPROBANTE DE PAGO Nº {{ $data['proof_number'] }}</h1>
        <div class="column-2">
            <p class="simple-text">{{ $data['company_rut'] }}</p>
            <p class="simple-text">{{ $data['company_name'] }}</p>
            <p class="simple-text"><span>Estado:</span> Vigente o en cartera</p>
        </div>
        <div class="column-2">
            <p class="simple-text" style="margin-left: 120px"><span>Fecha</span>: {{ $data['date'] }}</p>
            <p class="simple-text" style="margin-left: 120px"><span>Mes</span>: {{ $data['month'] }}</p>
            <p class="simple-text" style="margin-left: 120px"><span>Año</span>: {{ $data['year'] }}</p>
        </div>
    </div>

    {{-- Datos del cliente --}}
    <div>
        <h1 class="title">Datos del cliente</h1>
        <p class="simple-text"><span>Nombre</span>: {{ $data['client_name'] }}</p>
        <p class="simple-text"><span>RUT</span>: {{ $data['client_rut'] }}</p>
        <p class="simple-text"><span>Teléfono</span>: {{ $data['client_phone'] }}</p>
    </div>
    <br>

    {{-- Información de los tickets --}}
    <h2 class="simple-text">Documentos relacionados:</h2>
    <table>
        <tr>
            <th style="padding: 3px">Nº DOC</th>
            <th>TIPO DE DOCUMENTO</th>
            <th>FECHA DE DOCUMENTO</th>
            <th>MONTO($)</th>
            <th>PAGO REALIZADO($)</th>
        </tr>
        @foreach ($data['dataTickets'] as $ticket)
            <tr>
                <td>{{ $ticket['n_doc'] }}</td>
                <td>{{ $ticket['type_document'] }}</td>
                <td>{{ $ticket['date_document'] }}</td>
                <td>{{ $ticket['amount_document'] }}</td>
                <td>{{ $ticket['payment_ticket'] }}</td>
            </tr>
        @endforeach
    </table>
    <br>

    {{-- Forma de pago --}}
    <h2 class="simple-text" style="margin: none; padding: none">Detalle de forma de pago:</h2>
    <h1 class="title" style="margin: none; padding: none">{{ $data['way_to_pay'] }}</h1>

    {{-- Verificar si es un pago por crédito donde solo iría la cantidad de días que fue elegido --}}
    @php
        $moreInfo = true;
        if (is_null($data['date_admission'])) {
            $moreInfo = false;
        }
    @endphp

    @if ($moreInfo)
        <table>
            <tr>
                <th style="padding: 3px">FECHA DE INGRESO</th>
                <th>FECHA DE DOCUMENTO</th>
                <th>BANCO</th>
                <th>SERIE</th>
                <th>MONTO($)</th>
            </tr>
            <tr>
                <td>{{ $data['date_admission'] }}</td>
                <td>{{ $data['document_date'] }}</td>
                <td>{{ $data['bank_name'] }}</td>
                <td>{{ $data['serie'] }}</td>
                <td>{{ $data['amount'] }}</td>
            </tr>
        </table>
    @endif
    <br>
    <h2 class="simple-text" style="margin: none; padding: none"><span>Son:</span> {{ $data['amount_text'] }}</h2>
    <br>

    {{-- Estado de la cuenta del usuario logueado --}}
    @php
        $authorizedQuota = is_null($data['authorized_quota']) ? '-' : $data['authorized_quota'];
        $usedQuota = is_null($data['used_quota']) ? '-' : $data['used_quota'];
        $availableSpace = is_null($data['available_space']) ? '-' : $data['available_space'];
        $expiration = is_null($data['expiration']) ? '-' : $data['expiration'];
        $reconciledBy = $data['reconciled_by'] ?? '-';
    @endphp

    <div>
        <h2 class="title" style="font-size: 13px">ESTADO ACTUAL DE CUENTA CORRIENTE</h2>
        <div class="column-2">
            <p class="simple-text"><span>Documentos impago</span>: {{ $data['unpaid_docs'] }}</p>
            <p class="simple-text"><span>Usuario</span>: {{ $data['user'] }}</p>
        </div>
        <div class="column-2">
            <p class="simple-text"><span>Cupo autorizado</span>: {{ $authorizedQuota }}</p>
            <p class="simple-text"><span>Cupo utilizado</span>: {{ $usedQuota }}</p>
            <p class="simple-text"><span>Cupo disponible</span>: {{ $availableSpace }}</p>
            <p class="simple-text"><span>Vencimiento</span>: {{ $expiration }}</p>
        </div>
    </div>

    <h1 style="margin: 0px; padding: 0px">&nbsp;</h1> {{-- Por el uso de float necesito añadir un div extra son contenido --}}
    <div>
        <h2 class="simple-text">Estado de Ctacte actual ( {{ $data['date_creation'] }} // {{ $data['hour_creation'] }}) </h2>
    </div>
    <br><br><br>
    {{-- Datos del ingresante y conciliante --}}
    <div>
        <div class="column-2">
            <p class="simple-text"><span>____________________________________________</span></p>
            <p class="simple-text"><span>Ingresado por</span>: {{ $data['entered_by'] }}</p>
        </div>
        <div class="column-2">
            <p class="simple-text"><span>____________________________________________</span></p>
            <p class="simple-text"><span>Conciliado por:</span>: {{ $reconciledBy }}</p>
        </div>
    </div>
</body>
</html>
