<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante de pago</title>
    <style>
        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #0494b4;
            color: white;
            padding: 10px;
            text-align: center;
            font-weight: bold;
        }

        .message {
            font-size: 18px;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        .payment-info {
            background-color: #f2f2f2;
            padding: 10px;
            border-radius: 5px;
            display: flex;
            flex-wrap: wrap;
        }

        .payment-info h3 {
            width: 100%;
            text-align: center;
        }

        .payment-info p {
            margin: 5px 0;
            width: 100%;
            text-align: center;

        }

        .service-info {
            margin-top: 20px;
        }

        .detalle-producto {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }

        .detalle-producto h3 {
            width: calc(100% / 3);
            text-align: center;
        }

        .detalle-producto p {
            width: calc(100% / 3);
            text-align: center;
        }

        .anotation {
            display: flex;
            padding: 1px;
            border: #7da0a8 0.5px solid;
            border-radius: 20px;
            text-align: center;
            justify-content: center;
            align-items: center;
        }

        .anotation img{
            width: 60px;
            height: 50px;
            padding: 10px;
            margin: 10px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">Facturador</div>
        <div class="message">
            <p>Hola, {{$nameUser}}</p>
            <h1 style="text-align: center;">¡Queremos que te mantengas al día!</h1>
            <p style="text-align: center;">Te recordamos que tienes un comprobante de pago por vencer.</p>
        </div>
        <div class="anotation">
            <img src="https://cdn-icons-png.flaticon.com/512/1019/1019607.png" alt="hands-paying">
            <p>Realiza tus pagos a tiempo para evitar la suspensión de tu cuenta.</p>
        </div>
        <br>
        <div class="payment-info">
            <h3>Forma de pago seleccionado</h3>
            <p>Crédito</p>
        </div>
        <div class="detalle-producto">
            <h3>Nro de comprobante</h3>
            <h3>Vencimiento</h3>
            <h3>Monto</h3>
            <p>{{$receiptNumber}}</p>
            <p>{{$dueDate}}</p>
            <p>{{$amount}}</p>
        </div>
    </div>
</body>

</html>
