<?php

namespace Database\Seeders;

use App\Models\PaymentCuotas;
use App\Models\PaymentTools;
use App\Models\WayToPay;
use App\Models\WayToPayForCompany;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use function PHPSTORM_META\map;

class WayToPaySeeder extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $datawaytopay = [
            [
                "iderp" => null,
                "name" => "Contado",
                "agenda" => 0,
                "SII_fmapago" => "0",
                "status" => 1
            ],
            [
                "iderp" => null,
                "name" => "Crédito",
                "agenda" => 0,
                "SII_fmapago" => "0",
                "status" => 1
            ],
            [
                "iderp" => 221,
                "name" => "EFECTIVO",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 1
            ],
            [
                "iderp" => 2400,
                "name" => "GENERICO",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 2677,
                "name" => "TRANSBANK TD y TC",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 1
            ],
            [
                "iderp" => 4394,
                "name" => "PRUEBA PAGO AUTOMATICO",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 0
            ],
            [
                "iderp" => 4395,
                "name" => "OTROS PAGOS ELECTRONICOS",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 1
            ],
            [
                "iderp" => 5867,
                "name" => "30 DIAS",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 5868,
                "name" => "15 DIAS",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 5869,
                "name" => "45 DIAS",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 5870,
                "name" => "10 DIAS",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 5883,
                "name" => "60 dias",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 0
            ],
            [
                "iderp" => 5884,
                "name" => "90 dias",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 0
            ],
            [
                "iderp" => 5885,
                "name" => "120 dias",
                "agenda" => 0,
                "SII_fmapago" => "2",
                "status" => 1
            ],
            [
                "iderp" => 5982,
                "name" => "EFECTIVO prueba1",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 1
            ],
            [
                "iderp" => 5983,
                "name" => "EFECTIVO prueba2",
                "agenda" => 0,
                "SII_fmapago" => "1",
                "status" => 1
            ]
        ];
        WayToPay::insert($datawaytopay);

        $datapaymenttools = [
            ['name' => 'Transbank'],
            ['name' => 'Depósito'],
            ['name' => 'Giro'],
        ];
        PaymentTools::insert($datapaymenttools);

        $datacuotas = [
            ['numcuotas' => '2'],
            ['numcuotas' => '3'],
            ['numcuotas' => '4'],
            ['numcuotas' => '5'],
            ['numcuotas' => '6'],
            ['numcuotas' => '7'],
            ['numcuotas' => '8'],
            ['numcuotas' => '9'],
            ['numcuotas' => '10'],
            ['numcuotas' => '11'],
            ['numcuotas' => '12'],
        ];
        PaymentCuotas::insert($datacuotas);
    }

    public function runDataFake() {
    }
}
