<?php

namespace Database\Seeders;

use App\Models\UserType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserTypeSeeder extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $data = [
            ['name' => 'Superadministrador'],
            ['name' => 'Administrador'],
            ['name' => 'Vendedor'],
            ['name' => 'Proveedor'],
            ['name' => 'Cliente'],
        ];

        UserType::insert($data);
    }

    public function runDataFake() { }
}
