<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Crypt;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault(){
        User::create([
            'rut'               => '22222222-2',
            'username'          => 'lincoln',
            'email'             => 'lincoln@gmail.com',
            'password'          => bcrypt('demo'),
            'encrypted_password'=> Crypt::encryptString('demo'),
            'idcompany'         => 1
        ]);

        User::create([
            'rut'               => '33333333-3',
            'username'          => 'luis',
            'email'             => 'luis@gmail.com',
            'password'          => bcrypt('demo'),
            'encrypted_password'=> Crypt::encryptString('demo'),
            'idcompany'         => 1
        ]);

        User::create([
            'rut'               => '44444444-4',
            'username'          => 'vendedor',
            'email'             => 'vendedor@gmail.com',
            'password'          => bcrypt('demo'),
            'encrypted_password'=> Crypt::encryptString('demo'),
            'idcompany'         => 1
        ]);
    }

    public function runDataFake() {
    }
}
