<?php

namespace Database\Seeders;

use App\Models\UserERP;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Crypt;

class UserERPSeed extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $data = [
            [
                'rut'                   => '22222222-2',
                'user'                  => 'usuario',
                'password'              => bcrypt('demoerp'),
                'encrypted_password'    => Crypt::encryptString('demoerp')
            ],
            [
                'rut'                   => '76186513-7',
                'user'                  => 'erpsoftnet',
                'password'              => bcrypt('softnet.,2023'),
                'encrypted_password'    => Crypt::encryptString('softnet.,2023')
            ]
        ];

        UserERP::insert($data);
    }

    public function runDataFake()
    {
    }
}
