<?php

namespace Database\Seeders;

use App\Models\Url;
use Illuminate\Database\Seeder;

class UrlSeed extends Seeder
{
    public function run()
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {

        $data = [
            [
                'name' => 'back',
                'url' => 'http://localhost:8000'
            ],
            [
                'name' => 'front',
                'url' => 'http://127.0.0.1:5173'
            ],
            [
                'name' => 'Url de pago exitoso de Webpay',
                'url' => '/pagoexitoso/'
            ],
            [
                'name' => 'Url de pago fallido de Webpay',
                'url' => '/pagofallido/'
            ],
            [
                'name' => 'Membresía',
                'url' => '/membresias-active'
            ],
            [
                'name' => 'Pago de membresía exitoso',
                'url' => '/membresias-successfull'
            ]
        ];
        Url::insert($data);
    }

    public function runDataFake()
    {
    }
}
