<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UnitMeasureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_unit_measure')->insert([
            'name' => 'Unidad',
            'abbreviation' => 'ud',
        ]);
        DB::table('tbl_unit_measure')->insert([
            'name' => 'Kilogramo',
            'abbreviation' => 'kg',
        ]);
        DB::table('tbl_unit_measure')->insert([
            'name' => 'Litro',
            'abbreviation' => 'lt',
        ]);
        DB::table('tbl_unit_measure')->insert([
            'name' => 'Metros',
            'abbreviation' => 'm',
        ]);
    }

    public function runDataFake() { }
}
