<?php

namespace Database\Seeders;

use App\Models\TypeSale;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TypeSaleSeed extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault(){
        $data = [
            [
                'name'      => 'Delivery',
                'idcompany' => 1,
            ],
            [
                'name'      => 'Compra en tienda',
                'idcompany' => 1,
            ],
            [
                'name'      => 'Vendedor',
                'idcompany' => 1,
            ]
        ];

        TypeSale::insert($data);
    }

    public function runDataFake() {
    }
}
