<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TypeProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_types_products')->insert([
            'code' => 'PD',
            'name' => 'Productos de consumo',
            'description' => 'consumo personal',
        ]);

        DB::table('tbl_types_products')->insert([
            'code' => 'PN',
            'name' => 'Productos de negocios',
            'description' => 'reventa',
        ]);

        DB::table('tbl_types_products')->insert([
            'code' => 'PT',
            'name' => 'Productos según su duración y tangibilidad',
            'description' => 'según la cantidad de usos que se le da al producto y el tiempo que dura',
        ]);
    }

    public function runDataFake() { }
}
