<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TimeZoneSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_country_time_zone')->insert([
            'description'   => 'UTC/GMT -4 HOURS',
            'time_zone'     => 'America/Santiago'
        ]);

        DB::table('tbl_country_time_zone')->insert([
            'description'   => 'UTC/GMT +4 HOURS',
            'time_zone'     => 'America/Lima'
        ]);
    }

    public function runDataFake() { }
}
