<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SupplierSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */

    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_supplier')->insert([
            'rut'           => '12345678-1',
            'name_rz'       => 'cliente prueba',
            'fantasy_name'  => 'cliente',
            'web'           => 'cliente.com',
            'email'         => 'cliente@gmail.com',
            'phone'         => '985632154',
            'type'          => 1,
            'legal_nature'  => '33',
            'idwaytopay'    => 1,
            // 'idsalesman'    => 1,
            'idsegment'     => 1,
            'idcountry'     => 1,
            'iddepartment'  => 1,
            'idprovince'    => 1,
            'iddistrict'    => 1,
            'address'       => '',
            'idcompany'     => 1,
            'giro'          => 'Ventas y mas'
        ]);

        DB::table('tbl_supplier')->insert([
            'rut'           => '87654321-1',
            'name_rz'       => 'proveedor prueba',
            'fantasy_name'  => 'proveedor',
            'web'           => 'proveedor.com',
            'email'         => 'proveedor@gmail.com',
            'phone'         => '985632154',
            'type'          => 2,
            'legal_nature'  => '33',
            'idwaytopay'    => 2,
            // 'idsalesman'    => 1,
            'idsegment'     => 2,
            'idcountry'     => 1,
            'iddepartment'  => 1,
            'idprovince'    => 1,
            'iddistrict'    => 1,
            'address'       => '',
            'idcompany'     => 1,
            'giro'          => 'Ventas'
        ]);
    }

    public function runDataFake() { }
}
