<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubcategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Celulares y Teléfonos',
            'description' => 'Celulares y Teléfonos',
            'idspecificsubcategories' => '"[1,2]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Cámaras y Accesorios',
            'description' => 'Cámaras y Accesorios',
            'idspecificsubcategories' => '"[3,4]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Consolas y Videojuegos',
            'description' => 'Consolas y Videojuegos',
            'idspecificsubcategories' => '"[5,6]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Computación',
            'description' => 'Computación',
            'idspecificsubcategories' => '"[7,8,9]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Electrónica, Audio y Video',
            'description' => 'Electrónica, Audio y Video',
            'idspecificsubcategories' => '"[10,11,12]"',
            'idcompany' => 1 
        ]);

        //
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Seguridad Vehicular',
            'description' => 'Seguridad Vehicular',
            'idspecificsubcategories' => '"[13,14,15]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Iluminación',
            'description' => 'Iluminación',
            'idspecificsubcategories' => '"[16,17,18]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Climatización',
            'description' => 'Climatización',
            'idspecificsubcategories' => '"[19,20]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Llantas y Accesorios',
            'description' => 'Llantas y Accesorios',
            'idspecificsubcategories' => '"[21,22]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Frenos',
            'description' => 'Frenos',
            'idspecificsubcategories' => '"[23,24]"',
            'idcompany' => 1 
        ]);

        //
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Futbol',
            'description' => 'Futbol',
            'idspecificsubcategories' => '"[25,26,27]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Basquet',
            'description' => 'Basquet',
            'idspecificsubcategories' => '"[28,29,30]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Natación',
            'description' => 'Natación',
            'idspecificsubcategories' => '"[31,32]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Voleibol',
            'description' => 'Voleibol',
            'idspecificsubcategories' => '"[33]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Ropa Deportiva',
            'description' => 'Ropa Deportiva',
            'idspecificsubcategories' => '"[34,35,36,37]"',
            'idcompany' => 1 
        ]);

        //
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Cuidado de la salud',
            'description' => 'Cuidado de la salud',
            'idspecificsubcategories' => '"[38,39]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Equipamiento Médico',
            'description' => 'Equipamiento Médico',
            'idspecificsubcategories' => '"[40,41]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Ortopedia',
            'description' => 'Ortopedia',
            'idspecificsubcategories' => '"[42,43]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Suplementos',
            'description' => 'Suplementos',
            'idspecificsubcategories' => '"[]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Movilidad',
            'description' => 'Movilidad',
            'idspecificsubcategories' => '"[44,45,46]"',
            'idcompany' => 1 
        ]);

        //
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Bebidas',
            'description' => 'Bebidas',
            'idspecificsubcategories' => '"[47,48,49]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Congelados',
            'description' => 'Congelados',
            'idspecificsubcategories' => '"[50,51,52]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Comida Preparada',
            'description' => 'Comida Preparada',
            'idspecificsubcategories' => '"[53,54,55]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_sub_categories')->insert([
            'name' => 'Frescos',
            'description' => 'Frescos',
            'idspecificsubcategories' => '"[56,57,58,59]"',
            'idcompany' => 1 
        ]);
    }

    public function runDataFake() { }
}
