<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SegmentSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_segment')->insert([
            'name'    => 'Mayorista',
            'description' => null,
            'idcompany' => 1,
            'status'  => 1,
        ]);

        DB::table('tbl_segment')->insert([
            'name'    => 'Minorista',
            'description' => null,
            'idcompany' => 1,
            'status'  => 1,
        ]);

        DB::table('tbl_segment')->insert([
            'name'    => 'NA',
            'description' => null,
            'idcompany' => 1,
            'status'  => 1,
        ]);
    }

    public function runDataFake() { }
}
