<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SalesmanSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_salesman')->insert([
            'rut'               => '44444444-4',
            'name'              => 'Benito',
            'surname'           => 'Martinez',
            'gender'            => 0,
            'type_person'       => 0,
            'age'               => 20,
            'birthdate'         => '2000-01-01',
            'email'             => "vendedor@vendedor.com",
            'idchannel'         => 1,
            'idcompany'         => 1,
        ]);
    }

    public function runDataFake() { }
}
