<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SaleChannelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_sale_channel')->insert([
            'name'              => 'Terreno',
            'idcompany'         => 1,
        ]);

        DB::table('tbl_sale_channel')->insert([
            'name'              => 'Distribuidor',
            'idcompany'         => 1,
        ]);

        DB::table('tbl_sale_channel')->insert([
            'name'              => 'Subdistribuidor',
            'idcompany'         => 1,
        ]);
    }

    public function runDataFake() { }
}
