<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PriceListSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_price_list')->insert([
            'code'    => 'LS-001',
            'name' => 'Lista N° 01',
            'creation_date' => date('Y-m-d'),
            'validity_date' => null,
            'document_state' => 0,
            'quantity_products' => 0,
            'type' => 1,
            'created_by' => 2,
            'idcompany' => 1,
            'status'  => 1,
        ]);
    }

    public function runDataFake() { }
}
