<?php

namespace Database\Seeders;

use App\Models\Permissions;
use Illuminate\Database\Seeder;

class PermissionsSeed extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $data = [
            [
                'name' => 'General',
                'route_group' => json_encode([
                    'ubigeo',
                    'company',
                    'branchoffice',
                    'businessarea',
                    'salesmanBranchOfficeService',
                    'customerWallet',
                    'permissions',
                    'initialStep',
                    'bank'
                ]),
                'description' => 'Permisos generales para todos los usuarios.'
            ],
            [
                'name' => 'Compañía',
                'route_group' => json_encode([
                    'companyDefaultPermissions',
                    'adminCompany',
                    'configuration'
                ]),
                'description' => 'Configuración de la compañía.'
            ],
            [
                'name' => 'Usuarios',
                'route_group' => json_encode(['user']),
                'description' => 'Usuarios dentro del sistema.'
            ],
            [
                'name' => 'Documentación y emisión',
                'route_group' => json_encode([
                    'documentofsales',
                    'referenceDocument',
                    'softnet',
                    'proofPayment'
                ]),
                'description' => 'Documentos de ventas y emisión de ventas.'
            ],
            [
                'name' => 'Pagos',
                'route_group' => json_encode(['waytopay']),
                'description' => 'Formas de realizar pagos.'
            ],
            [
                'name' => 'Almacén',
                'route_group' => json_encode(['store']),
                'description' => 'Almacenes por empresa.'
            ],
            [
                'name' => 'Productos',
                'route_group' => json_encode([
                    'productattribute',
                    'usageattributes',
                    'specificattributes',
                    'specificuses',
                    'category',
                    'subcategory',
                    'specificsubcategory',
                    'product',
                    'typeProduct',
                    'classification',
                    'segment'
                ]),
                'description' => 'Productos y sus atributos para búsquedas avanzadas.'
            ],
            [
                'name' => 'Importar productos',
                'route_group' => json_encode(['productImport', 'softnet']),
                'description' => 'Importar productos.'
            ],
            [
                'name' => 'Ventas',
                'route_group' => json_encode([
                    'saleChannel',
                    'supplier',
                    'salesman',
                    'typeSale'
                ]),
                'description' => 'Canales de ventas, proovedores y vendedores.'
            ],
            [
                'name' => 'Precios',
                'route_group' => json_encode([
                    'pricelist',
                    'pricelistproducts',
                    'priceListBranchOffice',
                    'priceListSegment',
                    'priceListCustomer',
                    'priceListSalesman',
                ]),
                'description' => 'Listas de precios de acuerdo a origen o punto final.'
            ],
            [
                'name' => 'Existencias',
                'route_group' => json_encode(['stockProduct', 'internalGuide']),
                'description' => 'Cantidad por producto.'
            ],
            [
                'name' => 'Proceso de compras',
                'route_group' => json_encode([
                    'shoppingCart',
                    'ticket',
                    'transbank'
                ]),
                'description' => 'Inicios y finalización de compras.'
            ],
            [
                'name' => 'Permisos',
                'route_group' => json_encode(['permissionsUser']),
                'description' => 'Permisos por usuario.'
            ],
            [
                'name' => 'Información de membresías',
                'route_group' => json_encode(['membership', 'membershipCosts']),
                'description' => 'Membresías paras las empresas.'
            ],
            [
                'name' => 'Pagos de membresías',
                'route_group' => json_encode(['membershipPayment']),
                'description' => 'Pagos de membresías para las empresas.'
            ],
        ];

        Permissions::insert($data);
    }

    public function runDataFake()
    {
    }
}
