<?php

namespace Database\Seeders;

use App\Models\DetailMembershipPayment;
use App\Models\MembershipCosts;
use App\Models\MembershipPlans;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;

class MembershipSeed extends Seeder
{
    public function run()
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {

        # Planes
        $dataPlans = [
            [
                'name' => 'Mensual',
                'month' => 1
            ],
            [
                'name' => 'Semestral',
                'month' => 6
            ],
            [
                'name' => 'Anual',
                'month' => 12
            ]
        ];
        MembershipPlans::insert($dataPlans);

        # Costos de membresías
        $dataMembershipCosts = [
            # Básico
            [
                'idplans' => '1',
                'idmembership' => '1',
                'amount' => '50.00',
                'cod_erp' => '0001',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '0.5'
            ],
            [
                'idplans' => '2',
                'idmembership' => '1',
                'amount' => '250.00',
                'cod_erp' => '0002',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '2.7'
            ],
            [
                'idplans' => '3',
                'idmembership' => '1',
                'amount' => '500.00',
                'cod_erp' => '0003',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '5.4'
            ],
            #Estándar
            [
                'idplans' => '1',
                'idmembership' => '2',
                'amount' => '75.00',
                'cod_erp' => '0004',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '0.8'
            ], [
                'idplans' => '2',
                'idmembership' => '2',
                'amount' => '400.00',
                'cod_erp' => '0005',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '4.3'
            ],
            [
                'idplans' => '3',
                'idmembership' => '2',
                'amount' => '800.00',
                'cod_erp' => '0006',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '8.4'
            ],
            #Pro
            [
                'idplans' => '1',
                'idmembership' => '3',
                'amount' => '100.00',
                'cod_erp' => '0007',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '1'
            ],
            [
                'idplans' => '2',
                'idmembership' => '3',
                'amount' => '550.00',
                'cod_erp' => '0008',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '5.3'
            ],
            [
                'idplans' => '3',
                'idmembership' => '3',
                'amount' => '1000.00',
                'cod_erp' => '0009',
                'date_start' => '2023-01-01',
                'date_end' => '2023-12-31',
                'UF'    =>  '10.4'
            ]
        ];
        MembershipCosts::insert($dataMembershipCosts);

        # Data de empresa base
        DetailMembershipPayment::create([
            'idcompany'             => 1,
            'idmembershipcosts'     => 9,
            'payment_date'          => now(),
            'payment_date_end'      => now()->addYear(),
            'status_page'           => 1,
            'status_invoice'        => 0
        ]);

        # Actualizar precios de membresías por el comando
        Artisan::call('update:priceMembership');
    }

    public function runDataFake()
    {
    }
}
