<?php

namespace Database\Seeders;

use App\Models\DetInitialStep;
use App\Models\InitialStep;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class InitialStepSeed extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $data = [
            [
                'description' => 'Migrar categorías'
            ],
            [
                'description' => 'Migrar subcategorías'
            ],
            [
                'description' => 'Migrar productos'
            ]
        ];
        InitialStep::insert($data);

        $data2 = [
            [
                'idinitial_step' => 1,
                'key_plan'  => 'basic',
                'order' => 1
            ],
            [
                'idinitial_step' => 1,
                'key_plan'  => 'standar',
                'order' => 1
            ],
            [
                'idinitial_step' => 1,
                'key_plan'  => 'pro',
                'order' => 1
            ],
            [
                'idinitial_step' => 2,
                'key_plan'  => 'basic',
                'order' => 2
            ],
            [
                'idinitial_step' => 2,
                'key_plan'  => 'standar',
                'order' => 2
            ],
            [
                'idinitial_step' => 2,
                'key_plan'  => 'pro',
                'order' => 2
            ],
            [
                'idinitial_step' => 3,
                'key_plan'  => 'basic',
                'order' => 3
            ],
            [
                'idinitial_step' => 3,
                'key_plan'  => 'standar',
                'order' => 3
            ],
            [
                'idinitial_step' => 3,
                'key_plan'  => 'pro',
                'order' => 3
            ]
        ];
        DetInitialStep::insert($data2);
    }

    public function runDataFake()
    {
    }
}
