<?php

namespace Database\Seeders;

use App\Models\DocumentOfSale;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DocumentOfSaleSeeder extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        $data = [
            [
                'name' => 'Boleta electrónica',
                'cod_erp'  => 39
            ],
            [
                'name' => 'Factura',
                'cod_erp'  => 33
            ],
            [
                'name' => 'Nota de Crédito',
                'cod_erp'  => 61
            ],
            [
                'name' => 'Nota de Débito',
                'cod_erp'  => 1
            ],
            [
                'name' => 'Cotización',
                'cod_erp'  => 777
            ],
            [
                'name' => 'Nota de venta',
                'cod_erp'  => 780
            ]
        ];

        DocumentOfSale::insert($data);
    }

    public function runDataFake()
    {
    }
}
