<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_country')->insert([
            'code'          => 'CL',
            'abbreviation'  => 'CHL',
            'name'          => 'Chile',
            'nationality'   => 'Chileno',
            'language'      => 'spanish',
            'coin'          => 'PESOS',
            'coin_code'     => 'CLP',
            'idtimezone'     => 1,
        ]);

        DB::table('tbl_country')->insert([
            'code'          => 'PE',
            'abbreviation'  => 'PE',
            'name'          => 'Perú',
            'nationality'   => 'Peruano',
            'language'      => 'spanish',
            'coin'          => 'SOLES',
            'subdivision_coin' => 'CÉNTIMOS',
            'coin_code'     => 'SOL',
            'idtimezone'     => 2,
        ]);
    }

    public function runDataFake() { }
}
