<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\CompanyConfiguration;
use App\Models\DocumentOfSaleForCompany;
use App\Models\Membership;
use App\Models\Store;
use App\Models\WayToPayForCompany;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CompanySeed extends Seeder
{
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        # Membresías
        $dataMembership = [
            [
                'name'          => 'Básico',
                'key'           => 'basic',
                'view_pay'      => 1,
                'url_redirect'  => 'pay_basic'
            ],
            [
                'name'          => 'Estándar',
                'key'           => 'standar',
                'view_pay'      => 1,
                'url_redirect'  => 'pay_standar'
            ],
            [
                'name'          => 'Pro',
                'key'           => 'pro',
                'view_pay'      => 1,
                'url_redirect'  => 'pay_pro'
            ],
            [
                'name'          => 'Vencido',
                'key'           => 'null',
                'view_pay'      => 1,
                'url_redirect'  => 'nopay'
            ]
        ];
        Membership::insert($dataMembership);

        Company::create([
            'rut'           => '22222222-2',
            'business_name' => 'EMPRESA DEMO',
            'address'       => 'Calle tres 535 Bodega 6 Quilpue, Belloto Norte',
            'email'         => 'lincoln@softnet.cl',
            'phone'         => '+56 945566309',
            'giro'          => 'VENTAS DE PRODUCTOS',
            'iddistrict'    => 347,
            'idmembership'  => 3,
        ]);

        CompanyConfiguration::create([
            'idcompany' => 1,
            'inventory_configuration' => 2,
            'credit_terms'  => [15, 30, 45, 60],
            'cash_options'  => [1, 2]
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 1,
            'idcompany'          => 1
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 2,
            'idcompany'          => 1
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 3,
            'idcompany'          => 1
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 4,
            'idcompany'          => 1
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 5,
            'idcompany'          => 1
        ]);

        DocumentOfSaleForCompany::create([
            'iddocument_of_sale' => 6,
            'idcompany'          => 1
        ]);

        WayToPayForCompany::create([
            'idway_to_pay'       => 1,
            'idcompany'          => 1
        ]);

        WayToPayForCompany::create([
            'idway_to_pay'       => 2,
            'idcompany'          => 1
        ]);

        // WayToPayForCompany::create([
        //     'idway_to_pay'       => 3,
        //     'idcompany'          => 1
        // ]);

        // WayToPayForCompany::create([
        //     'idway_to_pay'       => 4,
        //     'idcompany'          => 1
        // ]);

        Store::create([
            'code'          => '22222222-2',
            'name'          => 'general',
            'description'   => 'Bodega general',
            'idcompany'     => 1,
        ]);
    }

    public function runDataFake()
    {
    }
}
