<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CoinTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_coin_type')->insert([
            'code' => 'CLP',
            'name' => 'PESOS',
            'symbol' => 'CLP',
        ]);

        DB::table('tbl_coin_type')->insert([
            'code' => 'SOL',
            'name' => 'SOLES',
            'symbol' => 's/',
        ]);
    }

    public function runDataFake() { }
}
