<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_categories')->insert([
            'name' => 'Electrodomesticos',
            'description' => 'Electrodomesticos',
            'idsubcategories' => '"[]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Juegos y juguetes',
            'description' => 'Juegos y juguetes',
            'idsubcategories' => '"[]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Tecnología',
            'description' => 'Tecnología',
            'idsubcategories' => '"[1,2,3,4,5]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Accesorios para vehículos',
            'description' => 'Accesorios para vehículos',
            'idsubcategories' => '"[6,7,8,9,10]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Deportes y Fitnes',
            'description' => 'Deportes y Fitnes',
            'idsubcategories' => '"[11,12,13,14,15]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Salud y equipamiento médico',
            'description' => 'Salud y equipamiento médico',
            'idsubcategories' => '"[16,17,18,19,20]"',
            'idcompany' => 1 
        ]);
        DB::table('tbl_categories')->insert([
            'name' => 'Alimentos y Bebidas',
            'description' => 'Alimentos y Bebidas',
            'idsubcategories' => '"[21,22,23,24]"',
            'idcompany' => 1 
        ]);
    }

    public function runDataFake() { }
}
