<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BranchOfficeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'General',
            'status'  => 1,
        ]);
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'Urbanas',
            'status'  => 1,
        ]);
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'Rurales',
            'status'  => 1,
        ]);
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'Industriales',
            'status'  => 1,
        ]);
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'Principal',
            'status'  => 1,
        ]);
        DB::table('tbl_branch_office_type')->insert([
            'name'    => 'Teletrabajo',
            'status'  => 1,
        ]);
    }

    public function runDataFake() { }
}
