<?php

namespace Database\Seeders;

use App\Models\Bank;
use Illuminate\Database\Seeder;

class BankSeed extends Seeder
{
    public function run()
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {

        $data = [
            [
                'name' => 'Banco de Chile',
                'code_SBIF' => '001',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Internacional',
                'code_SBIF' => '009',
                'idcountry' => 1
            ],
            [
                'name' => 'Scotiabank Chile',
                'code_SBIF' => '014',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco de crédito e inversiones',
                'code_SBIF' => '016',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco BICE',
                'code_SBIF' => '028',
                'idcountry' => 1
            ],
            [
                'name' => 'HSBC Bank',
                'code_SBIF' => '031',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Santander',
                'code_SBIF' => '037',
                'idcountry' => 1
            ],
            [
                'name' => 'Itaú Corpbanca',
                'code_SBIF' => '039',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Security',
                'code_SBIF' => '049',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Falabella',
                'code_SBIF' => '051',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Ripley',
                'code_SBIF' => '053',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco Consorcio',
                'code_SBIF' => '055',
                'idcountry' => 1
            ],
            [
                'name' => 'Banco BTG Pactual',
                'code_SBIF' => '059',
                'idcountry' => 1
            ],
            [
                'name' => 'BancoEstado centro de servicios S.A.',
                'code_SBIF' => '277',
                'idcountry' => 1
            ],
            [
                'name' => 'JP Morgan Chase Bank',
                'code_SBIF' => '041',
                'idcountry' => 1
            ],
            [
                'name' => 'China Construction',
                'code_SBIF' => '060',
                'idcountry' => 1
            ],
            [
                'name' => 'Bank of China',
                'code_SBIF' => '061',
                'idcountry' => 1
            ]
        ];
        Bank::insert($data);
    }

    public function runDataFake()
    {
    }
}
