<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AdminCompanySeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_admin_company')->insert([
            'rut' => '33333333-3',
            'name' => 'Luis Fernando',
            'surname' => 'Ramirez Mendoza',
            'email' => 'luis@gmail.com',
            'idcompany' => 1
        ]);
    }

    public function runDataFake() { }
}
