<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AccountStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->runDataDefault();
        if (env('PROJECT_MODE', 'prod') === 'dev') {
            $this->runDataFake();
        }
    }

    public function runDataDefault()
    {
        DB::table('tbl_account_status')->insert([
            'name'    => 'Saldo pendiente',
            'status'  => 1,
        ]);
        DB::table('tbl_account_status')->insert([
            'name'    => 'Pago realizado',
            'status'  => 1,
        ]);
    }

    public function runDataFake() { }
}
