<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_client_address', function (Blueprint $table) {
            $table->id();
            
            # Relaciones
            $table->unsignedBigInteger('idclient')->comment('ID del cliente relacionado, si aplica');
            $table->unsignedBigInteger('idcountry')->comment('ID del país');
            $table->unsignedBigInteger('iddepartment')->comment('ID del departamento');
            $table->unsignedBigInteger('idprovince')->comment('ID de la provincia');
            $table->unsignedBigInteger('iddistrict')->comment('ID del distrito');
            $table->unsignedBigInteger('idcompany')->comment('ID de la compañía');

            # Campos generales
            $table->string('address', 100)->comment('Dirección del proveedor');
            $table->string('email', 100)->nullable()->comment('Correo electrónico del proveedor');
            $table->char('status', 1)->default('1')->comment('0: Inactivo, 1: Activo, 2: Eliminado');
            
            # Relaciones con otras tablas
            $table->foreign('idclient')->references('id')->on('tbl_supplier');
            $table->foreign('idcountry')->references('id')->on('tbl_country');
            $table->foreign('iddepartment')->references('id')->on('tbl_department');
            $table->foreign('idprovince')->references('id')->on('tbl_province');
            $table->foreign('iddistrict')->references('id')->on('tbl_district');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_client_address');
    }
};
