<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_setting_billing', function (Blueprint $table) {
            $table->id();
            $table->char('documenttype', 1)->comment('1:boleta, 2:factura');
            $table->char('calculationtype', 1)->default(0)->comment('1:Netos, 2:Brutos');
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

           $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_setting_billing');
    }
};
