<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_client_setting', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idclient')->comment('ID del cliente relacionado, si aplica');
            $table->bigInteger('idbusiness_area')->unsigned();
            $table->bigInteger('idway_pay')->unsigned();
            $table->bigInteger('idaddress')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            
            $table->foreign('idclient')->references('id')->on('tbl_supplier');
            $table->foreign('idbusiness_area')->references('id')->on('tbl_business_area');
            $table->foreign('idway_pay')->references('id')->on('tbl_way_to_pay');
            $table->foreign('idaddress')->references('id')->on('tbl_client_address');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->char('status', 1)->default('1')->comment('0: Inactivo, 1: Activo, 2: Eliminado');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_client_setting');
    }
};
