<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_proof_payment', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('payment_method')->comment('1: Contado, 2: Crédito');
            $table->bigInteger('idway_to_pay_for_company')->unsigned()->comment('Método de pago de la empresa');
            $table->text('idstickets')->comment('Ids de tickets');
            $table->bigInteger('iduser_created')->unsigned();
            $table->date('date_admission')->nullable()->comment('Fecha de ingreso');
            $table->date('document_date')->nullable()->comment('Fecha del documento');
            $table->bigInteger('idbank')->nullable()->unsigned();
            $table->string('serie')->nullable()->comment('Número de serie/número de operación');
            $table->string('amount')->nullable();
            $table->string('amount_text')->nullable();
            $table->integer('unpaid_documents')->comment('Documentos impago');
            $table->dateTime('date_creation');
            $table->string('authorized_quota')->nullable()->comment('Cupo autorizado');
            $table->string('used_quota')->nullable()->comment('Cupo utilizado');
            $table->string('available_space')->nullable()->comment('Cupo disponible');
            $table->dateTime('expiration')->nullable()->comment('Vencimiento');
            $table->char('expiration_email')->nullable(0)->comment('Correo de envío de vencimiento, 0: No enviado, 1: Enviado');
            $table->text('document_url')->nullable();
            $table->bigInteger('accepted_iduser')->nullable()->unsigned()->comment('Solo requiere verificación en: Cheque, Transferencia');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('idway_to_pay_for_company')->references('id')->on('tbl_way_to_pay_for_company');
            $table->foreign('idbank')->references('id')->on('tbl_bank');
            $table->foreign('iduser_created')->references('id')->on('tbl_user');
            $table->foreign('accepted_iduser')->references('id')->on('tbl_user');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_proof_payment');
    }
};
