<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_bank', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code_SBIF')->nullable();
            $table->bigInteger('idcountry')->unsigned();
            $table->char('status', 1)->default(1);

            $table->foreign('idcountry')->references('id')->on('tbl_country');

        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_bank');
    }
};
