<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_admin_company', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15);
            $table->string('name', 100);
            $table->string('surname', 100);
            $table->string('email', 100);
            $table->string('phone', 15)->nullable();
            $table->string('address')->nullable();
            $table->date('birth_date')->nullable();
            // $table->integer('idcharge_erp')->nullable();
            $table->bigInteger('idcompany')->unsigned();
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->char('status', 1)->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_admin_company');
    }
};
