<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_internal_guide_detail', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idinternal_guide')->nullable()->unsigned();
            $table->string('code');
            $table->bigInteger('idproduct')->unsigned();
            $table->string('detail');
            $table->integer('count');
            $table->decimal('cost', 10, 2);
            $table->char('discount_type', 1)->comment('1: Porcentaje, 2: Pesos');
            $table->decimal('discount_amount', 10, 2)->comment('Monto o porcentaje a descontar');
            $table->decimal('discount', 10, 2)->comment('Descuento realizado');
            $table->decimal('total', 10, 2)->comment('Total de producto');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idinternal_guide')->references('id')->on('tbl_internal_guide');
            $table->foreign('idproduct')->references('id')->on('tbl_products');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_internal_guide_detail');
    }
};
