<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_internal_guide', function (Blueprint $table) {
            $table->id();
            $table->string('correlative')->comment('correlativo por empresa - Por tipo documento (500, 501, 502)');
            $table->date('date');
            $table->char('operation', 1)->comment('1:Ingreso, 2:Egreso');
            $table->bigInteger('idstore')->nullable()->unsigned()->comment('Bodega');
            $table->bigInteger('iddocument')->nullable()->unsigned()->comment('Tipo de documento');
            $table->string('folio');
            $table->bigInteger('idsupplier')->unsigned()->comment('Rut proveedor');
            $table->bigInteger('idcompany')->unsigned();
            $table->integer('internal_number')->comment('Número interno');
            $table->text('observation')->nullable();
            $table->text('observation_cancellation')->nullable();
            $table->string('total');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idstore')->references('id')->on('tbl_store');
            $table->foreign('iddocument')->references('id')->on('tbl_document_of_sale');
            $table->foreign('idsupplier')->references('id')->on('tbl_supplier');
            $table->foreign('idcompany')->references('id')->on('tbl_company');

        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_internal_guide');
    }
};
