<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_detail_membership_payment', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idcompany')->unsigned();
            $table->bigInteger('idmembershipcosts')->unsigned();
            $table->bigInteger('idpay')->unsigned()->nullable();
            $table->dateTime('payment_date');
            $table->dateTime('payment_date_end');
            $table->char('status_page', 1)->default(1)->comment('0: Pasado , 1: Actual , 2: Atrasado');
            $table->char('status_invoice', 1)->default(0)->comment('0: Emitido , 1: No emitido');
            $table->text('url_invoice')->nullable();
            $table->char('status', 1)->default(1);

            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('idmembershipcosts')->references('id')->on('tbl_membership_costs');
            $table->foreign('idpay')->references('id')->on('tbl_pay');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_detail_membership_payment');
    }
};
