<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_membership_costs', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idplans')->unsigned();
            $table->bigInteger('idmembership')->unsigned();
            $table->integer('amount');
            $table->date('date_start');
            $table->date('date_end');
            $table->text('cod_erp');
            $table->decimal('UF', 3, 1)->nullable();
            $table->char('status', 1)->default(1);

            $table->foreign('idplans')->references('id')->on('tbl_membership_plans');
            $table->foreign('idmembership')->references('id')->on('tbl_membership');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_membership_costs');
    }
};
