<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_company_configuration', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idcompany')->unsigned();
            $table->integer('inventory_configuration')->comment('1:Sin Inventario, 2:Inventario (sin control), 3:Inventario(controlado)');
            $table->text('credit_terms')->comment('Plazos de crédito')->nullable();
            $table->text('cash_options')->comment('Opciones de contado')->nullable();
            $table->char('payment_validation', 1)->default(1)->comment('1: Requiere ,2: No requiere');
            $table->char('status', 1)->default(1)->comment('0:Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_company_configuration');
    }
};
