<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_permissions_user', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('iduser')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->text('permissions')->comment('Array con ids de la tabla tbl_permissions');
            $table->text('actions')->comment('1:Lectura, 2:Escritura, 3:Edición, 4:Eliminado');
            $table->char('status', 1)->default(1)->comment('0:Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iduser')->references('id')->on('tbl_user');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_permissions_user');
    }
};
