<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_company_default_permissions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idcompany')->unsigned();
            $table->bigInteger('iduser_type')->unsigned();
            $table->text('permissions')->comment('Array con ids de la tabla tbl_permissions');
            $table->char('status', 1)->default(1)->comment('0:Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('iduser_type')->references('id')->on('tbl_user_type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_company_default_permissions');
    }
};
