<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_pay', function (Blueprint $table) {
            $table->id();
            $table->char('pay_type', 1)->default(1)->comment('1:Ticket, 2:Costo de membresía');
            $table->bigInteger('idregister')->nullable()->unsigned()->comment('Registro pagado');
            $table->bigInteger('iduser')->unsigned();
            $table->float('amount', 20, 3)->unsigned();
            $table->string('purchase_identifier');
            $table->string('token')->nullable();
            $table->char('transaction_status', 1)->default(0)->comment('0: En espera, 1: Válidado, 2: Inválido');
            $table->dateTime('creation_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->char('status', 1)->default(0)->comment('0:Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('iduser')->references('id')->on('tbl_user');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_pay');
    }
};
