<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_user_erp', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('iduser')->unsigned();
            $table->string('rut',15);
            $table->string('user', 50);
            $table->text('password');
            $table->text('encrypted_password')->nullable();
            $table->char('status', 1)->default(1)->comment('0=Inactivo, 1=Activo, 2=Eliminado');

            $table->foreign('iduser')->references('id')->on('tbl_user');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_user_erp');
    }
};
