<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_customer_reference_documents', function (Blueprint $table) {
            $table->id();
            $table->string('folio');
            $table->text('description');
            $table->bigInteger('iddocument_of_sale')->unsigned();
            $table->bigInteger('idcustomer')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iddocument_of_sale')->references('id')->on('tbl_document_of_sale');
            $table->foreign('idcustomer')->references('id')->on('tbl_supplier');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_customer_reference_documents');
    }
};
