<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_detail_ticket', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idticket')->unsigned();
            $table->bigInteger('idpricelist_product')->unsigned()->nullable();
            $table->bigInteger('idproduct')->unsigned();
            $table->integer('amount')->default(0);
            $table->float('price', 20, 3)->default(0);
            $table->integer('discount')->default(0);
            $table->char('discounttype', 1)->default(1)->comment('1=$, 2=%, 3=sin descuento');
            $table->float('gross_subtotal', 20, 3)->default(0);
            $table->float('net_subtotal', 20, 3)->default(0);
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idticket')->references('id')->on('tbl_ticket');
            $table->foreign('idpricelist_product')->references('id')->on('tbl_detail_pricelist_products');
            $table->foreign('idproduct')->references('id')->on('tbl_products');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_detail_ticket');
    }
};
