<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_ticket', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->string('nro_ticket');
            $table->bigInteger('iduser_created')->unsigned();
            $table->bigInteger('idcustomer')->unsigned();
            $table->bigInteger('idclient_address')->unsigned();
            $table->string('seller_rut', 30)->nullable();
            $table->float('gross_total', 20, 3)->default(0);
            $table->float('IVA', 20, 3)->default(0);
            $table->float('net_total', 20, 3)->default(0);
            $table->float('mnt_excent', 20, 3)->default(0)->comment('monto excento')->nullable();
            $table->char('discounttype', 1)->default(1)->comment('1:$, 2:%');
            $table->float('total_discount', 20, 3)->default(0);
            $table->float('total', 20, 3)->default(0)->comment('Total a pagar');
            $table->bigInteger('idtype_document')->unsigned();
            $table->bigInteger('idsale_channel')->unsigned()->nullable();
            // $table->integer('payment_condition');
            $table->bigInteger('idway_to_pay')->unsigned();
            $table->integer('bussines_area')->unsigned();
            $table->string('observation');
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status_ticket', 1)->default(1)->comment('1:Abierto, 2:Cerrado, 3:Cancelado');
            $table->char('status_invoice', 1)->default(0)->comment('0: No emitido, 1: Emitido');
            $table->char('issued_proof_payment', 1)->default(0)->comment('0: No emitido, 1: Emitido - Comprobante de pago');
            $table->float('proof_payment_amount', 20, 3)->nullable()->comment('Monto pagado al emitir el comprobante de pago');
            $table->text('url_invoice')->nullable();
            $table->string('folio', 100)->nullable();
            $table->char('payment_status', 1)->default(2)->comment('1:Pagado, 2:No pagado');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iduser_created')->references('id')->on('tbl_user');
            $table->foreign('idcustomer')->references('id')->on('tbl_supplier');
            $table->foreign('idclient_address')->references('id')->on('tbl_client_address');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('idtype_document')->references('id')->on('tbl_document_of_sale');
            $table->foreign('idsale_channel')->references('id')->on('tbl_sale_channel');
            $table->foreign('idway_to_pay')->references('id')->on('tbl_way_to_pay');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_ticket');
    }
};
