<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_shopping_cart', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('iduser_created')->unsigned();
            $table->bigInteger('idcustomer')->unsigned()->nullable();
            $table->char('documenttype', 1)->default(1)->comment('1:boleta, 2:factura');
            $table->float('global_discount', 20, 3)->default(0);
            $table->float('net_total', 20, 3)->default(0)->comment('total neto');
            $table->float('IGV', 20, 3)->default(0);
            $table->float('gross_total', 20, 3)->default(0)->comment('total bruto');
            $table->float('total_discount', 20, 3)->default(0)->comment('total descuento');
            $table->float('total', 20, 3)->default(0)->comment('total a pagar');
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status_ticket', 1)->default(0)->comment('0: No emitido, 1:Emitido');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iduser_created')->references('id')->on('tbl_user');
            $table->foreign('idcustomer')->references('id')->on('tbl_supplier');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_shopping_cart');
    }
};
