<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_detail_pricelist_salesman', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idpricelist')->unsigned();
            $table->bigInteger('idsalesman')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idpricelist')->references('id')->on('tbl_price_list');
            $table->foreign('idsalesman')->references('id')->on('tbl_salesman');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_detail_pricelist_salesman');
    }
};
